local super = require "Object"

SortRule = super:new()

local defaults = {
    direction = SortDataPresenter.ascendingDirection,
}

local nilDefaults = {
    'artifact',
}

function SortRule:new()
    self = super.new(self)
    
    for k, v in pairs(defaults) do
        self:addProperty(k, v)
    end
    for _, k in pairs(nilDefaults) do
        self:addProperty(k)
    end
    
    return self
end

function SortRule:evaluate(dataset)
    local artifact = self:getArtifact()
    return (artifact and artifact:evaluate(dataset)) or Sequence:newWithArray({})
end

function SortRule:setArtifact(artifact)
    self:setProperty('artifact', artifact)
end

function SortRule:getArtifact()
    return self:getProperty('artifact') or IndexArtifact:new()
end

function SortRule:setDirection(direction)
    self:setProperty('direction', direction)
end

function SortRule:getDirection()
    return self:getProperty('direction')
end

return SortRule
